#define vec2 float2
#define vec3 float3
#define vec4 float4
#define rgb xyz
#define rgba xyzw

const sampler_t sampler = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_CLAMP_TO_EDGE | CLK_FILTER_LINEAR;
const sampler_t sampler1 = CLK_NORMALIZED_COORDS_TRUE | CLK_ADDRESS_MIRRORED_REPEAT  | CLK_FILTER_LINEAR;

float noise1(__read_only image2d_t texture,float t)
{
	return read_imagef(texture,sampler1,(vec2)(t,0.0f)/(vec2)(96.0f)).x;
}
float noise2(__read_only image2d_t texture,vec2 t)
{
    vec2 tc = t/(vec2)(96.0f);
    // tc.y = 1.0f-tc.y;
	return read_imagef(texture,sampler1,tc).x;
}
vec3 lensflare(__read_only image2d_t texture,vec2 uv,vec2 pos)
{
	vec2 main = uv-pos;
	vec2 uvd = uv*(length(uv));
	
	float ang = atan2(main.x,main.y);
	float dist=length(main); 
    dist = pow(dist,0.1f);
	float n = noise2(texture,(vec2)(ang*16.0f,dist*32.0f));
	
	float f0 = 1.0f/(length(uv-pos)*16.0f+1.0f);
	
	f0 = f0 + f0*(sin(noise1(texture,sin(ang*2.0f+pos.x)*4.0f - cos(ang*3.0f+pos.y))*16.0f)*0.1f + dist*0.1f + 0.8f);
	
	float f1 = max(0.01f-pow(length(uv+1.2f*pos),1.9f),0.0f)*7.0f;

	float f2 = max(1.0f/(1.0f+32.0f*pow(length(uvd+0.8f*pos),2.0f)),0.0f)*0.25f;
	float f22 = max(1.0f/(1.0f+32.0f*pow(length(uvd+0.85f*pos),2.0f)),0.0f)*0.23f;
	float f23 = max(1.0f/(1.0f+32.0f*pow(length(uvd+0.9f*pos),2.0f)),0.0f)*0.21f;
	
	vec2 uvx = mix(uv,uvd,-0.5f);
	
	float f4 = max(0.01f-pow(length(uvx+0.4f*pos),2.4f),0.0f)*6.0f;
	float f42 = max(0.01f-pow(length(uvx+0.45f*pos),2.4f),0.0f)*5.0f;
	float f43 = max(0.01f-pow(length(uvx+0.5f*pos),2.4f),0.0f)*3.0f;
	
	uvx = mix(uv,uvd,-0.4f);
	
	float f5 = max(0.01f-pow(length(uvx+0.2f*pos),5.5f),0.0f)*2.0f;
	float f52 = max(0.01f-pow(length(uvx+0.4f*pos),5.5f),0.0f)*2.0f;
	float f53 = max(0.01f-pow(length(uvx+0.6f*pos),5.5f),0.0f)*2.0f;
	
	uvx = mix(uv,uvd,-0.5f);
	
	float f6 = max(0.01f-pow(length(uvx-0.3f*pos),1.6f),0.0f)*6.0f;
	float f62 = max(0.01f-pow(length(uvx-0.325f*pos),1.6f),0.0f)*3.0f;
	float f63 = max(0.01f-pow(length(uvx-0.35f*pos),1.6f),0.0f)*5.0f;
	
	vec3 c = (vec3)(0.0f);
	
	c.x+=f2+f4+f5+f6;
    c.y+=f22+f42+f52+f62;
    c.z+=f23+f43+f53+f63;
	c = c*1.3f - (vec3)(length(uvd)*0.05f);
	c+=(vec3)(f0);
	
	return c;
}
vec3 cm(vec3 color, float factor,float factor2) 
{
	float w = color.x+color.y+color.z;
	return mix(color,(vec3)(w)*factor,w*factor2);
}
__kernel void MAIN(
      __read_only image2d_t input1,
	  __read_only image2d_t input2,
      __write_only image2d_t dest_data,
      __global FilterParam* param,
	  int alpha)
{	

	 int outputW = param->width[1];
	int outputH = param->height[1];
    int W = get_global_size(0);
	int H = get_global_size(1);
    float2 ouputResolution = (float2)(W,H);  
    int2 gl_FragCoord = (int2)(get_global_id(0), get_global_id(1));

    vec2 fragCoord = (vec2)(get_global_id0( param), get_global_id1( param));
    vec2 resolution = ouputResolution;
	vec2 tc = ((float2)(fragCoord.x, fragCoord.y) + (vec2)(0.5f))/ouputResolution.xy;

    vec2 uv = (float2)(tc.x, tc.y)*(vec2)(param->origROI[2], param->origROI[3]) + (vec2)(param->origROI[0], param->origROI[1]);

    float4 orig = read_imagef(input1, sampler, uv);     
    
    float fragX = (float)(get_global_id(0) - get_global_offset(0));
    float fragY = (float)(get_global_id(1) - get_global_offset(1));
    vec2 frag = (vec2)(fragX,fragY) + (vec2)(0.5f);
    vec2 uv2 = frag / ouputResolution.xy;
	
    float time = param->cur_time;
     
    uv2 = uv2 - (vec2)(0.5f);
    float ratio = (float)(W)/(float)(H);
	uv2.x *= ratio; //fix aspect ratio   

    float iTime = param->cur_time;
   
    vec2 mouse = (vec2)(0.0f);
	
	mouse.x *= ratio; //fix aspect ratio
	mouse.x=sin(iTime)*0.5f;
    mouse.y=-sin(iTime*0.913f)*0.5f;
	
	vec3 color = (vec3)(1.4f,1.2f,1.0f)*lensflare(input2,uv2,mouse.xy);
	color -= noise2(input2,frag.xy)*0.015f;
	color = cm(color,0.5f,0.1f);
	vec4 fragColor = (vec4)(color,1.0f);
 
    fragColor.xyz = 1.0f - (1.0f - orig.xyz)*(1.0f-fragColor.xyz);
	
	vec4 outColor = mix(fragColor, orig, (float4)(1.0f - (float)alpha/100.0f));

    write_imagef(dest_data, gl_FragCoord, outColor);
}


    